#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Byt3-daily-006Mod01.fsh   by  byt3_m3chanic   
//https://www.shadertoy.com/view/l3GSzy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/** 

    License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License

    Byt3-daily-006
    Angled truchets / playing with some moving patterns. Started as an experiment with
    checking neighbors and ended up as this.
     
    07/04/2024  @byt3_m3chanic
    
*/

#define R           iResolution
#define T           iTime
#define M           iMouse
#define PI          3.14159265359
#define PI2         6.28318530718

mat2 rot(float a) {return mat2(cos(a),sin(a),-sin(a),cos(a));}
float hash21(vec2 a){ return fract(sin(dot(a,vec2(22.54,35.45)))*4823.232);}
float box(vec2 p, vec2 a) {vec2 q=abs(p)-a;return length(max(q,0.))+min(max(q.x,q.y),0.);}

mat2 r45;
// @morgan3d https://www.shadertoy.com/view/4dS3Wd
float noise (in vec2 uv) {
    vec2 i = floor(uv),f = fract(uv);
    float a = hash21(i);
    float b = hash21(i + vec2(1,0));
    float c = hash21(i + vec2(0,1));
    float d = hash21(i + vec2(1,1));
    vec2 u = f * f * (3.-2.*f);
    float nn =  mix(a, b, u.x) + (c-a)* u.y * (1.-u.x) + (d-b)* u.x * u.y;
    if(uv.y<1. && uv.y>-1.&&a>.5) nn = 0.;
    return nn;
}

vec3 truchet(vec2 p) {
    vec2 uv = p;
    uv *= 12.; uv -= vec2(T*.75,.85*sin(T*.4));
    
    vec2 id = floor(uv), q = fract(uv)-.5, suv = q;
    float hs = hash21(id);

    const float sx = .35;
    // cheap check of the hood
    float ns = noise(id*sx);
    vec4 hhs = vec4(
        noise((id.xy+vec2(0,-1))*sx),
        noise((id.xy+vec2(1,0))*sx),
        noise((id.xy+vec2(0,1))*sx),
        noise((id.xy+vec2(-1,0))*sx)
    );
    
    float rnd = fract(hs*4324.79);
    if(rnd>.5) q.xy*= rot(1.5707);
    
    const float pf = .353, wd = .13;
    vec2 q2 = q; q *= r45;
    
    // main pattern
    float pq = length(q.x+pf)<length(q.x-pf)? q.x+pf : q.x-pf;
    float d = length(pq);
    d = abs(d) - wd;
    
    // alt pattern
    if(hs>.65) {
        d = min(length(q2.x),length(q2.y))-(wd*1.4);
        float xd = length(abs(q2.x)-(wd*1.5))-(wd*.12);
        d = max(d,-xd);
    }

    // edge block check and patterns
    const float thr = .35;
    if(ns<thr) {
        d = 1.;
        // prob could do better with logic but first stab at it..
        if(rnd>.5) { q2.xy*= rot(-1.5707); }
        if(hhs.x>thr) d = min(min(box(q2+vec2(0,.5),vec2(wd*1.4)),length(q2+vec2(0,.32))-(wd*1.4)), d);
        if(hhs.z>thr) d = min(min(box(q2-vec2(0,.5),vec2(wd*1.4)),length(q2-vec2(0,.32))-(wd*1.4)), d);
        if(hhs.y>thr) d = min(min(box(q2-vec2(.5,0),vec2(wd*1.4)),length(q2-vec2(.32,0))-(wd*1.4)), d);
        if(hhs.w>thr) d = min(min(box(q2+vec2(.5,0),vec2(wd*1.4)),length(q2+vec2(.32,0))-(wd*1.4)), d);
        
        float ck = mod(id.y+id.x,2.);
        if(hhs.x<thr&&hhs.y>thr&&hhs.z<thr&&hhs.w<thr&&ck<1.) d = min(box(q2-vec2(.2,0),vec2(wd*3.4,wd*1.4)),length(q2+vec2(.2,0))-(wd*1.4));
        if(hhs.x<thr&&hhs.y<thr&&hhs.z>thr&&hhs.w<thr&&ck<1.) d = min(box(q2-vec2(0,.2),vec2(wd*1.4,wd*3.5)),length(q2+vec2(0,.2))-(wd*1.4));
        if(hhs.x<thr&&hhs.y<thr&&hhs.z<thr&&hhs.w>thr&&ck<1.) d = min(box(q2+vec2(.2,0),vec2(wd*3.4,wd*1.4)),length(q2-vec2(.2,0))-(wd*1.4));
        if(hhs.x>thr&&hhs.y<thr&&hhs.z<thr&&hhs.w<thr&&ck<1.) d = min(box(q2+vec2(0,.2),vec2(wd*1.4,wd*3.4)),length(q2-vec2(0,.2))-(wd*1.4));
      
        if(hhs.z>thr&&hhs.x>thr&&hhs.y<thr&&hhs.w<thr) d = length(abs(q2.x))-(wd*1.39);
        if(hhs.w>thr&&hhs.y>thr&&hhs.x<thr&&hhs.z<thr) d = length(abs(q2.y))-(wd*1.39);
        
        if(hhs.x>thr&&hhs.y>thr&&hhs.z<thr&&hhs.w<thr) d = rnd<.5? abs(length(q.y+pf) ) - wd : abs(length(q.x+pf) ) - wd;
        if(hhs.z>thr&&hhs.w>thr&&hhs.x<thr&&hhs.y<thr) d = rnd<.5? abs(length(q.y-pf) ) - wd : abs(length(q.x-pf) ) - wd;
        if(hhs.w>thr&&hhs.x>thr&&hhs.z<thr&&hhs.y<thr) d = rnd>.5? abs(length(q.y-pf) ) - wd : abs(length(q.x+pf) ) - wd;
        if(hhs.z>thr&&hhs.y>thr&&hhs.w<thr&&hhs.x<thr) d = rnd>.5? abs(length(q.y+pf) ) - wd : abs(length(q.x-pf) ) - wd;
    }

    return vec3(d,uv);
}
#define O fragColor
#define F fragCoord

//void mainImage( out vec4 O, in vec2 F ) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    r45 = rot(.7853981634);
    
    vec2 uv = (2.*F-R.xy)/max(R.x,R.y); 
    float px = fwidth(uv.x); 


    vec3 C = mix(vec3(.1),vec3(.5),clamp((uv.y+.5),0.,1.));
    
    vec3 dt = truchet(uv);
    vec3 st = truchet(uv+vec2(uv.x/8.,uv.y/6.));
    float d = dt.x;
    float s = st.x;

    // prep background and domain
    const float sc = 42.;
    vec2 id = floor(uv*sc);
    float hs = hash21(id);
    uv.x += .15*sin(id.y*.133+T*.66);
    
    id = floor(uv*sc);
    uv = fract(uv*sc)-.5;
    
    // background dots
    float d2 = length(uv)-.3;
    if(mod(id.x+id.y,2.)<1.){
    C = mix(C,vec3(.3),smoothstep(px,-px,d2));
    C = mix(C,mix(vec3(.2),vec3(.6),uv.y),smoothstep(px,-px,abs(d2)-.035));
    }

    // truchet and accent
    C = mix(C,C*.65,smoothstep(.1+px,-px,s+.01));
    C = mix(C,C*.45,smoothstep(.05+px,-px,d-.04));
    C = mix(C,clamp(C+.3,vec3(0),vec3(1)),smoothstep(px,-px,d));
    C = mix(C,mix(vec3(0),vec3(.65),.5+.5*sin(dt.z*PI2+T*2.)),smoothstep(px,-px,abs(d+.02)-.02));

    // gamma and output
    C = pow(C,vec3(.4545));
    fragColor = vec4(C,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

